try:
    import pygame
except ImportError:
    pygame = None

black    = (   0,   0,   0)
white    = ( 255, 255, 255)
green    = (   0, 200,   0)
orange = (255, 165, 0)
maroon      = ( 100,   0,   0)
red = (255, 0, 0 )
blue    = ( 0, 0, 255 )
yellow = (255, 255, 0)
pink = (255,20,147)

size = [800,800]
import random
import math
import numpy

# 213 agents can completely cover the space
# OR 1 agent can completely search the space in 213 cycles

class Swarm:

##    num = 0
    def __init__(self,size,wts):
        self.agents = []
        num = 0
        for i in range(size):
            num += 1
            self.agents.append(Agent(num,wts))
        self.size = size
        self.base_x = 400
        self.base_y = 400
        self.mines_found = 0
        self.agents_remaining = size

    def update(self,objects,screen='NULL'):
        for a in self.agents:
            a.update(objects,screen)

    def draw(self,screen):
        pygame.draw.circle(screen,green,(400,400),30,4)
        for a in self.agents:
            a.draw(screen)

    def check_deaths(self):
##        print len(self.agents)
        length = len(self.agents)
        for n, a in enumerate(reversed(self.agents)):
##            print n
            if a.bat <= 0:
##                print len(self.agents), len(self.agents)-n-1
##                print self.agents[length-n-1].bat
                del self.agents[length-n-1]
##                print a.bat
        return len(self.agents)

    def count(self):
        total = 0.0
        num_in_bounds = 0.0
        percent_in_bounds = 0.0
        max_limit = math.sqrt((size[0]//2)**2+(size[1]//2)**2)
        for a in self.agents:
            total += 1
            mid_x = size[0]//2
            mid_y = size[1]//2
            d = math.sqrt(((mid_x-a.x)**2)+((mid_y-a.y)**2))
            if d < max_limit and a.bat > 0:
                num_in_bounds += 1
##        if total > 0:
##            percent_in_bounds = num_in_bounds/self.size
##        else:
##            precent_in_bounds = 0.0
        percent_in_bounds = float(num_in_bounds/self.size)
        return round(percent_in_bounds,2)

    def update(self,(s,m)):
        for a in self.agents:
            a.update((s,m))

class Agent:

    def __init__(self,num,wts):

        self.task = 0 # Explore, 1 -> Report, 2 -> Recharge
        self.w = wts[:]
        self.num = num
        self.max_x = size[0]
        self.max_y = size[1]
        self.r = 4
        self.bat = 100
        self.x = random.randint(size[0]//2-20,size[0]//2+20)
        self.y = random.randint(size[1]//2-20,size[1]//2+20)
        self.dx = 0
        self.dy = 0
        self.mineFound = False
        self.reporting = False
        self.speed = float(random.randint(20,60)/10)
        self.broadcasting = False
        self.mineX = 0
        self.mineY = 0
        self.tag_backs = 0
##        for i in range(3):
##            self.w[60+i] = self.w[60+i] + random.uniform(-3,3)
##        for i in range(2):
##            self.w[63+i] = self.w[63+i] + random.uniform(-12,12)
##        for i in range(6):
##            self.w[65+i] = self.w[65+i] + random.uniform(-6,6)
##        for i in range(6):
##            self.w[71+i] = self.w[71+i] + random.uniform(-6,6)

    def closest_agent_weights(self,d,task,sensor_range):
##        return (0,0)
        h = float(sensor_range//2)
        if task == 0: # Explore
            if d < h:
                return (((self.w[1]-self.w[0])/h)*d + self.w[0],((self.w[4]-self.w[3])/h)*d + self.w[3])
            else:
                return (((self.w[2]-self.w[1])/h)*(d-h) + self.w[1],((self.w[5]-self.w[4])/h)*(d-h) + self.w[4])
        elif task == 1: # Report
            if d < sensor_range//2:
                return (((self.w[7]-self.w[6])/h)*d + self.w[6],((self.w[10]-self.w[9])/h)*d + self.w[9])
            else:
                return (((self.w[8]-self.w[7])/h)*(d-h) + self.w[7],((self.w[11]-self.w[10])/h)*(d-h) + self.w[10])
        else: # Recharge
            if d < sensor_range//2:
                return (((self.w[13]-self.w[12])/h)*d + self.w[12],((self.w[16]-self.w[15])/h)*d + self.w[15])
            else:
                return (((self.w[14]-self.w[13])/h)*(d-h) + self.w[13],((self.w[17]-self.w[16])/h)*(d-h) + self.w[16])

    def mine_weights(self,d,task,sensor_range):
##        return (0,0)
        h = float(sensor_range//2)
        if task == 0: # Explore
            if d < h:
                return (((self.w[19]-self.w[18])/h)*d + self.w[18],((self.w[22]-self.w[21])/h)*d + self.w[21])
            else:
                return (((self.w[20]-self.w[19])/h)*(d-h) + self.w[19],((self.w[23]-self.w[22])/h)*(d-h) + self.w[22])
        elif task == 1: # Report
            if d < sensor_range//2:
                return (((self.w[25]-self.w[24])/h)*d + self.w[24],((self.w[28]-self.w[27])/h)*d + self.w[27])
            else:
                return (((self.w[26]-self.w[25])/h)*(d-h) + self.w[25],((self.w[29]-self.w[28])/h)*(d-h) + self.w[28])
        else: # Recharge
            if d < sensor_range//2:
                return (((self.w[31]-self.w[30])/h)*d + self.w[30],((self.w[34]-self.w[33])/h)*d + self.w[33])
            else:
                return (((self.w[32]-self.w[31])/h)*(d-h) + self.w[31],((self.w[35]-self.w[34])/h)*(d-h) + self.w[34])

    def base_weights(self,d,task,sensor_range):
##        return (0,0)
        h = float(sensor_range//2)
        if task == 0: # Explore
            if d < h:
                return (((self.w[37]-self.w[36])/h)*d + self.w[36],((self.w[40]-self.w[39])/h)*d + self.w[39])
            else:
                return (((self.w[38]-self.w[37])/h)*(d-h) + self.w[37],((self.w[41]-self.w[40])/h)*(d-h) + self.w[40])
        elif task == 1: # Report
            if d < sensor_range//2:
                return (((self.w[43]-self.w[42])/h)*d + self.w[42],((self.w[46]-self.w[45])/h)*d + self.w[45])
            else:
                return (((self.w[44]-self.w[43])/h)*(d-h) + self.w[43],((self.w[47]-self.w[46])/h)*(d-h) + self.w[46])
        else: # Recharge
            if d < sensor_range//2:
                return (((self.w[49]-self.w[48])/h)*d + self.w[48],((self.w[52]-self.w[51])/h)*d + self.w[51])
            else:
                return (((self.w[50]-self.w[49])/h)*(d-h) + self.w[49],((self.w[53]-self.w[52])/h)*(d-h) + self.w[52])

    def center(self,d,task):\
##        return 0
        if task == 0:
            h = float(self.w[57])
            if d < h:
                return 0
            else:
                return min((self.w[54]/h)*(d-h),6)
        elif task == 1:
            h = float(self.w[58])
            if d < h:
                return 0
            else:
                return min((self.w[55]/h)*(d-h),6)
        else:
            h = float(self.w[59])
            if d < h:
                return 0
            else:
                return min((self.w[56]/h)*(d-h),6)

    def draw(self,screen):
        x = int(self.x)
        y = int(self.y)
        if self.task == 0:
            color = blue
            pygame.draw.circle(screen,color,(x,y),self.r)
        elif self.task == 1:
            color = maroon
            pygame.draw.polygon(screen,color,[(self.x-self.r,self.y-self.r),(self.x-self.r,self.y+self.r),(self.x+self.r,self.y+self.r),(self.x+self.r,self.y-self.r)])
        else:
            color = green
            pygame.draw.polygon(screen,color,[(self.x-self.r,self.y+self.r),(self.x,self.y-self.r),(self.x+self.r,self.y+self.r)])
##        pygame.draw.circle(screen,color,(x,y),self.r)

    def update(self,(s,m)):

        self.broadcasting = False
        heard_broadcast = False

        discharge_rate_active = 0.02
        discharge_rate_passive = 0.05

        # Twiddle
        self.dx += random.uniform(-2,0) + random.uniform(0,2)
        self.dy += random.uniform(-2,0) + random.uniform(0,2)

        # Check for nearest agent
        agent_Seen = False
        num_agents = 0
        sensor_range = 25
        closest_x = 0
        closest_y = 0
        closest_d = sensor_range
        for a in s.agents:
            d = distance(self,a)
            if 0 < d < sensor_range:
                if a.broadcasting:
                    heard_broadcast = True
                    agent_talking = a
                    bcast_mineX = a.mineX
                    bcast_mineY = a.mineY
                    bcast_mineF = a.mineF
                agent_Seen = True
                num_agents += 1
                if d < closest_d:
                    closest_x = a.x
                    closest_y = a.y
                    closest_d = d
        if agent_Seen:
            (to,pl) = self.closest_agent_weights(closest_d,self.task,sensor_range)
            self.dx += float(to) * (closest_x-self.x) / closest_d
            self.dy += float(to) * (closest_y-self.y) / closest_d
            self.dx += float(pl) * (closest_y-self.y) / closest_d
            self.dy -= float(pl) * (closest_x-self.x) / closest_d

        # Check for nearest mine
        mine_Seen = False
        sensor_range = 25
        closest_x = 0
        closest_y = 0
        closest_d = sensor_range
        for mine in m.m:
            d = distance(self,mine)
            if 0 < d < sensor_range:
                if mine.found == False and self.task!=2:
                    mine.found = True
                    m.mines_found += 1
                    m.mines_not_found -= 1
                mine_Seen = True
                if d < closest_d and self.task!=2:
                    closest_x = mine.x
                    closest_y = mine.y
                    closest_d = d
                    mineX = mine.x
                    mineY = mine.y
                    found_mine = mine
                    self.mineFound = True
            if d < 10:
                self.bat = 0
        if mine_Seen:
##            print "mine seen"
            (to,pl) = self.mine_weights(closest_d,self.task,sensor_range)
            self.dx += float(to) * (closest_x-self.x) / closest_d
            self.dy += float(to) * (closest_y-self.y) / closest_d
            self.dx += float(pl) * (closest_y-self.y) / closest_d
            self.dy -= float(pl) * (closest_x-self.x) / closest_d

        # Check to see if the base is within range
        base_Seen = False
        sensor_range = 30
        d = math.sqrt(((self.x-s.base_x)**2)+((self.y-s.base_y)**2))
        if 0 < d < sensor_range:
            base_Seen = True
        if base_Seen:
##            print "Base seen"
            (to,pl) = self.base_weights(d,self.task,sensor_range)
            self.dx += float(to) * (s.base_x-self.x) / d
            self.dy += float(to) * (s.base_y-self.y) / d
            self.dx += float(pl) * (s.base_y-self.y) / d
            self.dy -= float(pl) * (s.base_x-self.x) / d
        # Recharge battery:
        recharge_range = 30
        if 0 < d < recharge_range:
            dif = float(100 - self.bat)
##            print self.bat, self.bat+(dif*.1)
            self.bat += dif * .1

        # Check to see if the agent is too far away from the base
        if d > 0:
            self.dx += float(self.center(d,self.task)) * (s.base_x-self.x) / d
            self.dy += float(self.center(d,self.task)) * (s.base_y-self.y) / d
        if d > 600:
            self.bat = 0.0

        if self.tag_backs > 0:
            self.tag_backs -= 1

        if self.task == 0: # If agent is in explore mode
##            bat = self.bat*100
            # Switch to report?
            k1 = [self.w[63],self.w[64],self.w[65],self.w[72]]
            k2 = [self.w[66],self.w[67],self.w[68],self.w[73]]
##            relD = d/self.speed
##            if relD == 0:
##                relD = 0.1
            if mine_Seen:
                if not found_mine.reported:

##                    x = (self.bat*k1[0])/relD
##                    x = ((self.bat-(relD*discharge_rate))/100.0)*k1[0]
##                    y = k1[1]*num_agents
                    i1 = self.bat/100.0
                    i2 = d/600.0
                    i3 = (self.speed-2.0)/4.0
                    output = (i1*k1[0])+(i2*k1[1])+(i3*k1[2])
                    if output > k1[3]:# and y > k1[3]:

                        self.task = 1
                        self.mineX = mineX
                        self.mineY = mineY
                        self.mineF = found_mine
                        self.reporting = True
##                        self.mine_Found = True

            if heard_broadcast:

##                x = (self.bat*k2[0])/relD
##                x = ((self.bat-(relD*discharge_rate))/100.0)*k2[0]
##                y = k2[1]*num_agents
                i1 = self.bat/100.0
                i2 = d/600.0
                i3 = (self.speed-2.0)/4.0
                output = (i1*k2[0])+(i2*k2[1])+(i3*k2[2])
                if output > k2[3]:#k2[3]:# and y > k2[3]:

                    self.task = 1
                    self.mineX = bcast_mineX
                    self.mineY = bcast_mineY
                    self.mineF = bcast_mineF
                    self.mine_Found = True
                    self.reporting = True
                    agent_talking.broadcasting = False
                    agent_talking.task = 0
                    self.tag_backs = 10


            # Switch to recharge?
            t = self.w[61]
##            k3 = [self.w[61],self.w[75],self.w[76],self.w[77]]
##            i1 = bat/100.0
##            i2 = d/600.0
##            i3 = (self.speed-2.0)/4.0
##            output = (i1*k3[1])+(i2*k3[2])+(i3*k3[3])
##            relD = d/self.speed
           #x = self.bat*self.w[63]/relD
##            x = self.bat - (relD*discharge_rate)
##            prob_switch2Recharge = ((x**4)/((x**4)+(t**4)))
##            r = random.uniform(0,1)
##            if r < prob_switch2Recharge:
##                self.task = 2
            if self.bat < t:
                self.task = 2

        elif self.task == 1: # If agent is in report mode
##            bat = self.bat * 100
            # Switch to explore
##            relD = d/self.speed
##            if relD == 0:
##                relD = 0.1
            k = [self.w[69],self.w[70],self.w[71],self.w[74]]
            if agent_Seen:
                i1 = self.bat/100.0
                i2 = d/600.0
                i3 = (self.speed-2.0)/4.0
                output = (i1*k[0])+(i2*k[1])+(i3*k[2])
##                x = (self.bat*k[0])/relD
##                x = ((self.bat-(relD*discharge_rate))/100.0)*k[0]
##                y = k[1]*num_agents
                if output > k[3] and self.tag_backs == 0:# and y > k[3]:
                    self.broadcasting = True

            # Switch to recharge?
            t = self.w[62]
##            relD = d/self.speed
##            bat = self.bat*100
##            x = self.bat*self.w[64]/relD
##            x = self.bat - (relD*discharge_rate)
##            prob_switch2Recharge = ((x**4)/((x**4)+(t**4)))
##            r = random.uniform(0,1)
##            if r < prob_switch2Recharge:
##                self.task = 2
            if self.bat < t:
                self.task = 2

            # Is agent close enough to the base to report mine position
            if d < recharge_range and self.reporting:
                if self.mineF.reported == False:
                    self.mineF.reported = True
                    m.mines_reported += 1
                    m.mines_not_reported -= 1
                self.mineFound = False
                self.reporting = False
                self.task = 0

        else: # If agent is in recharge mode
            t = self.w[60]
##            bat = self.bat*100
##            prob_switch2Explore = ((self.bat**4)/((self.bat**4)+(t**4)))
##            x = random.uniform(0,1)
##            if x < prob_switch2Explore:
##                self.task = 0
##            if d < recharge_range and self.reporting:
##                if self.mineF.reported == False:
##                    self.mineF.reported = True
##                    m.mines_reported += 1
##                    m.mines_not_reported -= 1
##                self.mineFound = False
##                self.reporting = False
            if self.bat > t:
                self.task = 0


        # Check speed
        current_speed = math.sqrt((self.dx**2)+(self.dy**2))
        if current_speed > self.speed:
            self.dx = float(self.dx) / (current_speed) * float(self.speed)
            self.dy = float(self.dy) / (current_speed) * float(self.speed)

        # Deplete portion of battery

        dist = math.sqrt((self.dx**2)+(self.dy**2))
        self.bat -= discharge_rate_active * dist
        self.bat -= discharge_rate_passive


##        if self.num == 1:
##            print self.bat
##        tx = self.x
        if self.bat > 0:
            self.x += self.dx
            self.y += self.dy
##        if self.num == 1:
##            print tx,self.dx,self.x

def distance(agent1,agent2):
    return math.sqrt(((agent1.x-agent2.x)**2)+((agent1.y-agent2.y)**2))

class Mines:

    def __init__(self,num):
        self.m = []
        self.mines_found = 0
        self.mines_not_found = num
        self.mines_reported = 0
        self.mines_not_reported = num
        for i in range(num):
            self.m.append(Mine())

    def draw(self,screen):
        for m in self.m:
            m.draw(screen)

class Mine:

    num = -1
    def __init__(self):
        Mine.num += 1
        self.num = Mine.num
        angle = random.uniform(0,math.pi*2)
        distance = random.uniform(200,size[0]/float(2))
        self.x = int(distance*math.cos(angle))
        self.y = int(distance*math.sin(angle))
        self.x += int(size[0]/float(2))
        self.y += int(size[1]/float(2))
        self.found = False
        self.reported = False
        self.r = 7

    def draw(self,screen):
        if self.reported:
            color = black
        elif self.found:
            color = orange
        else:
            color = red
        pygame.draw.circle(screen,color,(self.x,self.y),self.r)






